<?php
// This script will update your Ace addons automatically with the libraries kept separately
// Usage: php ace_updater.php (optionally specify an addon name for single update mode)
// You will need to customize the following fields to your needs:

// Put a list here of the addons you want to download automatically when the script is run (libraries will be automatically determined based on the mod)
$addons = array(
 'Aloft',
 'BigWigs',
 'CooldownTimers2',
 'Demon',
 'Elephant',
 'Enhancer',
 'Grid',
 'GridAutoFrameSize',
 'GridLayoutForHealers',
 'Incubator',
 'LittleWigs',
 'LoggerHead',
 'MainAssist',
 'Omen',
 'oRA2',
 'Quartz',
 'Proximo',
 'RatingBuster',
 'Recount',
 'SpellBinder',
 'XRS',
 'WeaponRebuff'
);

// This is the path to your WoW interface folder
$wow_path = "/Applications/Games/World of Warcraft/Interface";

// Anything beyond this point will be automatically created so you don't need to touch unless you want to change the names

// This is the temporary directory that stores the downloaded addons
$temp_dir = $wow_path . "/AceDownloads";

// This is the temporary directory that stores the addons when they are unzipped until they are installed
$unzip_path = $temp_dir . "/Install";

// This is the directory where the previous version of any updated mods are moved to in case you run into a problem and need to get back the last version
$old_dir = $wow_path . "/OldAce";

// NOTHING USER ADJUSTABLE BEYOND THIS POINT

$files_url = "http://files.wowace.com"; # URL for Ace mod downloads
$noext_url = "no-ext"; # path for non extended version
$addon_path = $wow_path . "/AddOns"; # folder where the addons for WoW are stored
$embed_string = "## X-Embeds: "; # flag for libraries associated with a mod
$opt_string = "## OptionalDeps: "; # flag for optional dependencies associated with a mod
$get_opt = 0; # get optional dependencies, recommended to leave this off for now

$full_libs_list = $files_url . "/latest.xml"; # location for the full mod list

$libs_list = array();
$one_addon = '';

// parse xml for specific tag contents
function get_tag_contents($xmlcode,$tag) {
  $i=0;
  $offset=0;
  $xmlcode = trim($xmlcode);
  do{ #Step through each ocurrence of <$tag>...</$tag> in the XML
    #find the next start tag
    $start_tag=strpos ($xmlcode,"<".$tag.">",$offset);
    $offset = $start_tag;
    #find the closing tag for the start tag you just found
    $end_tag=strpos ($xmlcode,"</".$tag.">",$offset);
    $offset = $end_tag;
    #split off <$tag>... as a string, leaving the </$tag> 
    $our_tag = substr ($xmlcode,$start_tag,($end_tag-$start_tag));
    $start_tag_length = strlen("<".$tag.">");
    if (substr($our_tag,0,$start_tag_length)=="<".$tag.">"){
      #strip off stray start tags from the beginning
      $our_tag = substr ($our_tag,$start_tag_length);
    }
    $array_of_tags[$i] =$our_tag;
    $i++;
  }while(!(strpos($xmlcode,"<".$tag.">",$offset)===false));
return $array_of_tags;
}

// get the full mod list
function get_mod_list() {
 global $full_libs_list;
 
 print "Getting list of valid mods\n";

 $libs_xml = file_get_contents($full_libs_list);
 
 if (!$libs_xml) {
  print "Failed to download valid library list!\n";
  exit;
 }
 
 $valid_mods = array();
 
 // Some brilliant XML parsing happens here
 $item_array = get_tag_contents($libs_xml, "item");
 foreach ($item_array as $item) {
  # get the mod name
  $name_array = get_tag_contents($item, "title");
  $valid_mods[] = array_shift($name_array);
 }
 
 return($valid_mods);
}

// get the specified addon
function get_download($addon='') {
 global $files_url, $noext_url, $temp_dir, $libs_list, $embed_string, $opt_string, $unzip_path, $get_opt;
 
 if (!$addon) { return; }
 
 $addon_url = $files_url . "/" . $addon . "/" . $noext_url . "/" . $addon . ".zip";
 print "Downloading Addon: " . $addon . "\n";
 
 $temp_addon = file_get_contents($addon_url);
 
 if (!$temp_addon) {
  print "Failed to download $addon!\n";
  return;
 }
 
 $temp_filename = $temp_dir . "/" . $addon . ".zip";
 
 $temp_handle = fopen($temp_filename, "w");
 
 if (!$temp_handle) {
  print "Failed to write $temp_filename\n";
  return;
 }
 
 if (fwrite($temp_handle, $temp_addon) == FALSE) {
  print "Failed to write $temp_filename\n";
  return;
 }
 
 fclose($temp_handle);
 
 unzip_file($temp_filename);

 // Get library list
 $temp_toc = str_replace(" ", "\ ", $unzip_path . "/" . $addon . "/" . $addon . ".toc");
 $temp_embeds = shell_exec("grep \"$embed_string\" $temp_toc");
 $temp_embeds = str_replace($embed_string, "", $temp_embeds);
 $temp_embed_list = explode(", ", trim($temp_embeds));
 foreach ($temp_embed_list as $temp_embed) {
	if (!$temp_embed) { continue; }
 	if ($libs_list[$temp_embed]) {
 	 $libs_list[$temp_embed] .= ", " . $addon;
 	}
 	else {
	 $libs_list[$temp_embed] = $addon;
	}
 }
 
 // Get optional dependencies
 if ($get_opt) {
	 $temp_opt = shell_exec("grep \"$opt_string\" $temp_toc");
	 $temp_opt = str_replace($opt_string, "", $temp_opt);
	 $temp_opt_list = explode(", ", trim($temp_opt));
	 foreach ($temp_opt_list as $opt) {
		if (!$opt) { continue; }
		if (in_array($opt, $temp_embed_list)) { continue; }
		if ($libs_list[$opt]) {
		 $libs_list[$opt] .= ", " . $addon;
		}
		else {
		 $libs_list[$opt] = $addon;
		}
	 } 
 }
}

// unzip the specified file
function unzip_file($filename='') {
 if (!$filename) { return; }
 
 $filename = str_replace(" ", "\ ", $filename);
 $filename = str_replace("!", "\!", $filename);
 
// print "Unzipping $filename\n";
 
 $result = shell_exec("/usr/bin/unzip $filename");
 
// print "Result: $result\n";
}

// Recursively delete everything inside a starting directory
function recursive_delete($dir='') {
 if (!$dir) { return; }

 if (is_dir($dir)) {
	 if ($dh = opendir($dir)) {
		while (($file = readdir($dh)) !== false ) {
			 if ( $file != "." && $file != ".." ) {
				 if ( is_dir( $dir . "/" .  $file ) ) {
//					 echo "Entering Directory: $dir/$file\n";
					 recursive_delete( $dir . "/" . $file );
//					 echo "Removing Directory: $dir/$file\n";
					 rmdir( $dir . "/" . $file );
				 }
				 else {
//					 echo "Deleting file: $dir/$file\n";
					 unlink( $dir . "/" . $file );
				 }
			 }
		}
		closedir($dh);
	 }
 }
}

// update mods (backup old versions, install new versions)
function update_mods() {
 global $unzip_path, $addon_path, $old_dir, $embed_string, $libs_list;
 
 // go through the list of files in unzip_path
 if (is_dir($unzip_path)) {
  if ($dh = opendir($unzip_path)) {
   while (($file = readdir($dh)) !== false) {
    if (preg_match("/^\./", $file)) {
     continue;
    }
	// move each of their old versions to an old directory
    if (is_dir("$addon_path/$file")) {
//     print "Backing up the old $file\n";
     rename("$addon_path/$file", "$old_dir/$file");
    }
	// move each of them to the addon folder
    print "Installing the new $file\n";
    rename("$unzip_path/$file", "$addon_path/$file");
   }
  }
 }
}

// main processing

if ($_SERVER['argv'][1]) {
	$one_addon = $_SERVER['argv'][1];
	if (in_array($one_addon, $addons)) {
		print "Single mod update: $one_addon\n";
	}
	else {
		print "Error: Single mod mode specified but $one_addon is not in valid mods list\n";
		exit;
	}
}

// Make sure all the appropriate directories exist

// Make sure the WoW directory is valid
if (!(is_dir($wow_path))) {
	print "Error: Can't find your WoW installation at $wow_path\n";
	exit;
}

// Make sure the temp directory is created if it doesn't exist
if (!(is_dir($temp_dir))) {
	if (file_exists($temp_dir)) {
	 print "Error: There is already a file by the same name as the temp directory, can't create $temp_dir\n";
	 exit;
	}
	print "Couldn't find the temp directory, attempting to create $temp_dir\n";
	if (mkdir($temp_dir, 0755)) {
	 print "Successfully created $temp_dir\n";
	}
	else {
	 print "Error: Couldn't create $temp_dir\n";
	 exit;
	}
}

// Make sure the unzip directory is created if it doesn't exist
if (!(is_dir($unzip_path))) {
	if (file_exists($unzip_path)) {
	 print "Error: There is already a file by the same name as the unzip directory, can't create $unzip_path\n";
	 exit;
	}
	print "Couldn't find the unzip directory, attempting to create $unzip_path\n";
	if (mkdir($unzip_path, 0755)) {
	 print "Successfully created $unzip_path\n";
	}
	else {
	 print "Error: Couldn't create $unzip_path\n";
	 exit;
	}
}

// Make sure the Ace addon backup directory is created if it doesn't exist
if (!(is_dir($old_dir))) {
	if (file_exists($old_dir)) {
	 print "Error: There is already a file by the same name as the Ace addon backup directory, can't create $old_dir\n";
	 exit;
	}
	print "Couldn't find the Ace addon backup directory, attempting to create $old_dir\n";
	if (mkdir($old_dir, 0755)) {
	 print "Successfully created $old_dir\n";
	}
	else {
	 print "Error: Couldn't create $old_dir\n";
	 exit;
	}
}

// Get a list of valid mods
$valid_mods = get_mod_list();

// Clean up the install directory
print "Cleaning $unzip_path\n";
recursive_delete($unzip_path);

// Change into the unzip directory
if (chdir("$unzip_path") == FALSE) {
 print "Failed to switch to $unzip_path\n";
 exit;
}

// If this is single addon mode download the specified addon
if ($one_addon) {
 if (in_array($one_addon, $valid_mods)) {
  get_download($one_addon);
 }
 else {
  print "Error: " . $one_addon . " is not a valid Ace mod\n";
 }
}
// Otherwise, get all the addons
else {
 foreach ($addons as $addon) {
	if (in_array($addon, $valid_mods)) {
	 get_download($addon);
	}
	else {
	 print "Error: " . $addon . " is not a valid Ace mod\n";
	}
 }
}

// Clean up the libraries list, removing invalid libraries (usually sublibraries)
ksort($libs_list);
$clean_libs_list = array();

print "Libraries needed: \n";
foreach ($libs_list as $libname => $addons_used) {
	if (in_array($libname, $addons)) { continue; }
	if ($libname) {
	 print " - " . $libname . " ($addons_used)";
	 if (in_array($libname, $valid_mods)) {
	  $clean_libs_list[] = $libname;
	 }
	 else {
	  print " - skipping sublibrary";
	 }
	 print "\n";
	}
}

// Get all the libraries
foreach ($clean_libs_list as $libname) {
	get_download($libname);
}

// Clean up the old backup directory
print "Cleaning $old_dir\n";
recursive_delete($old_dir);

// Update all the mods found in the install directory
update_mods();
?>
